//Source file: F:\jschwartz\src\Alkindi\BusinessServices\IRecommendationManager.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Services;

import Alkindi.Data.RecommendationList;
import Alkindi.Data.Recommendation;
import Alkindi.Data.SystemUser;
import Alkindi.Data.Product;
import java.rmi.RemoteException;

/* 
$Header: IRecommendationManager.java, 12, 3/9/01 12:38:14 PM, Schwartz, Joe$
$Log: 
 12   Alkindi Development1.11        3/9/01 12:38:14 PM   Schwartz, Joe    
 11   Alkindi Development1.10        2/23/01 4:31:45 PM   Schwartz, Joe  
      Changed getPredictedRating to return a float.
 10   Alkindi Development1.9         2/12/01 10:37:27 AM  Schwartz, Joe  
      Changed getRecs to work given a PC list.
 9    Alkindi Development1.8         12/28/00 2:54:07 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 8    Alkindi Development1.7         12/28/00 1:07:08 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:12 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/20/00 8:19:06 PM  Schwartz, Joe   
 5    Alkindi Development1.4         11/6/00 11:50:05 AM  Schwartz, Joe   
 4    Alkindi Development1.3         10/19/00 1:12:03 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 3    Alkindi Development1.2         10/6/00 4:13:36 PM   Schwartz, Joe   
 2    Alkindi Development1.1         9/24/00 3:12:15 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:12:05 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This interface provides services related to recommendations.
 */
public interface IRecommendationManager 
{
	
	/**
	 * Calculates or retrieves the given user's Alkindex.
	 * @param user The User whose Alkindex is to be obtained.
	 * @return The Alkindex as a float.
	 * @throws AlkExcept
	 * @roseuid 39C919A60128
	 */
	public float getAlkindex(final Alkindi.Data.SystemUser user) throws RemoteException,AlkExcept;
	
	/**
	 * Obtains the Predicted Rating for a given User and Product.
	 * @param user The User for whom to calculate the rating.
	 * @param prod The Product for which to calculate the rating.
	 * @return The Predicted Rating as a float.
	 * @roseuid 3A3E86220399
	 */
	public float getPredictedRating(final Alkindi.Data.SystemUser user, final Alkindi.Data.Product prod) throws AlkExcept,RemoteException;
	
	/**
	 * This method retrieves a number of recommendations for the given user. If selects products from the given product group, unless productGroup is null.
	 * @param user The user for which to get recommendations.
	 * @param numDesired The number of recommendations to retrieve.
	 * @param pcList The Product Clusters from which to select.
	 * @return The recommendations are returned in a RecommendationList object.
	 * @throws AlkExcept
	 * @roseuid 399ABC140148
	 */
	public Alkindi.Data.RecommendationList getRecommendations(final Alkindi.Data.SystemUser user, final int numDesired, final Alkindi.Data.ProductClusterList pcList) throws AlkExcept,RemoteException;
	
	/**
	 * This method retrieves a number of recommendations for the given user. If selects products from the given product group, unless productGroup is null.
	 * @param user The user for which to get recommendations.
	 * @param numDesired The number of recommendations to retrieve.
	 * @return The recommen
	 * @roseuid 3A3E4A3002BF
	 */
	public Alkindi.Data.RecommendationList getRecommendations(final Alkindi.Data.SystemUser user, final int numRecs) throws AlkExcept,RemoteException;
}
